from flask import Markup

from psynet.modular_page import(
    ModularPage,
    Control
)

class ChordNAFCControl(Control):
    macro = "chord_nafc"
    external_template = "chord_nafc.html"

    def __init__(self, chords, f0):
        super().__init__()
        self.chords = chords
        self.f0 = f0

    @property
    def metadata(self):
        return {
            "chords": self.chords,
            "f0": self.f0
        }

class ChordRatingControl(Control):
    macro = "chord_rating"
    external_template = "chord_rating.html"

    def __init__(self, chords, f0):
        super().__init__()
        self.chords = chords
        self.f0 = f0

    @property
    def metadata(self):
        return {
            "chords": self.chords,
            "f0": self.f0
        }